/*	cclose.c	1.10	83/05/13	*/
#include <stdio.h>
#include "cpmio.h"
#include "cpmfio.h"

/************************************************************************
 * NAME:	cpm_file_close()
 *
 * DESCR:	Close the given file.  Flush it if necessary.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if the close worked, FALSE otherwise.
 *
 * NOTES:	
 ************************************************************************/
int
cpm_file_close(C_FILE *fptr)
{
	int	scts = 0;

	/* if in write mode, flush the file to disk	*/

	if (fptr->c_flag & WRITE) {
	    scts = (fptr->cpmfs->blksiz - fptr->c_cnt)/fptr->cpmfs->seclth + 1;
	    if (fptr->c_cnt%fptr->cpmfs->seclth == 0)
		scts--;
	    fptr->c_dirp->blkcnt = fptr->cpmfs->seclth/CPMSECSIZ * (scts + fptr->c_seccnt);
	    if (fptr->c_cnt < fptr->cpmfs->blksiz) {
		/* zero fill to end, and flush the block to disk */
		if ((fptr->c_flag&BINARY) == 0) {
		    *(fptr->c_buf++) = '\032';	/* add CPM eof (^Z) if text file	*/
		    fptr->c_cnt--;
		}
		while (fptr->c_cnt-- > 0)
		    *(fptr->c_buf++) = '\0';
	    }
	    if (!cpm_putblock(fptr->cpmfs, blockno(fptr,fptr->c_blk), fptr->c_base, scts)) {
		return (FALSE);
	    }
	    cpm_savedir(fptr->cpmfs);
	}

	/* deallocate buffer memory and file descriptor */
	fptr->c_flag = 0;
	free(fptr->c_base);
	return (TRUE);
}
